<?php
require_once '../config.php';
global $pdo;

// Optional filter
$filter = $_GET['filter'] ?? '';
$param = '%' . $filter . '%';

$stmt = $pdo->prepare("
    SELECT * FROM tracks
    WHERE (genre IS NULL OR mood IS NULL OR bpm IS NULL OR camelot IS NULL)
      AND (title LIKE :param OR artist LIKE :param)
    ORDER BY id DESC LIMIT 100
");
$stmt->execute([':param' => $param]);
$tracks = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Track Metadata Manager</title>
    <link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css' rel='stylesheet'>
</head>
<body class='bg-light'>
<div class='container mt-5'>
    <h2 class='mb-4'>📝 Track Metadata Editor</h2>

    <form class='mb-3' method='GET'>
        <input name='filter' class='form-control' placeholder='Filter by artist or title...' value='<?= htmlspecialchars($filter) ?>'>
    </form>

    <?php if (count($tracks) === 0): ?>
        <div class='alert alert-success'>🎉 No missing metadata or nothing matched your filter.</div>
    <?php else: ?>
        <form method='POST' action='save.php'>
            <table class='table table-bordered table-sm'>
                <thead class='table-dark'>
                    <tr>
                        <th>Title</th>
                        <th>Artist</th>
                        <th>BPM</th>
                        <th>Camelot</th>
                        <th>Genre</th>
                        <th>Style</th>
                        <th>Mood</th>
                        <th>Theme</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($tracks as $track): ?>
                    <tr>
                        <td><?= htmlspecialchars($track['title']) ?></td>
                        <td><?= htmlspecialchars($track['artist']) ?></td>
                        <input type='hidden' name='tracks[<?= $track['id'] ?>][id]' value='<?= $track['id'] ?>'>
                        <td><input name='tracks[<?= $track['id'] ?>][bpm]' class='form-control form-control-sm' value='<?= $track['bpm'] ?>'></td>
                        <td><input name='tracks[<?= $track['id'] ?>][camelot]' class='form-control form-control-sm' value='<?= $track['camelot'] ?>'></td>
                        <td><input name='tracks[<?= $track['id'] ?>][genre]' class='form-control form-control-sm' value='<?= $track['genre'] ?>'></td>
                        <td><input name='tracks[<?= $track['id'] ?>][style]' class='form-control form-control-sm' value='<?= $track['style'] ?>'></td>
                        <td><input name='tracks[<?= $track['id'] ?>][mood]' class='form-control form-control-sm' value='<?= $track['mood'] ?>'></td>
                        <td><input name='tracks[<?= $track['id'] ?>][theme]' class='form-control form-control-sm' value='<?= $track['theme'] ?>'></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            <button class='btn btn-primary'>💾 Save Changes</button>
        </form>
    <?php endif; ?>
</div>
</body>
</html>