<?php
function fetchMusicBrainzMetadata(string $artist, string $title): ?array {
    $query = http_build_query([
        'query' => "$title AND artist:$artist",
        'fmt' => 'json',
        'limit' => 1
    ]);
    $url = "https://musicbrainz.org/ws/2/recording/?$query";

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_USERAGENT => "SpottyData/1.0 ( https://dj.megaload.co.za )"
    ]);
    $res = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($res, true);
    if (!empty($data['recordings'][0])) {
        $recording = $data['recordings'][0];
        return [
            'tags' => array_column($recording['tags'] ?? [], 'name'),
            'release' => $recording['releases'][0]['title'] ?? null,
        ];
    }
    return null;
}
?>
