<?php
// lastfm_api.php
require_once 'config.php';  // Contains LASTFM_API_KEY

function getLastFMTrackTags($artist, $track) {
    $url = 'https://ws.audioscrobbler.com/2.0/?method=track.getInfo&api_key=' . LASTFM_API_KEY .
           '&artist=' . urlencode($artist) . '&track=' . urlencode($track) . '&format=json';

    $json = @file_get_contents($url);
    if (!$json) return [];

    $data = json_decode($json, true);
    if (!isset($data['track'])) return [];

    $trackData = $data['track'];

    // Try extract metadata
    $tags = $trackData['toptags']['tag'] ?? [];
    $tagNames = array_map(fn($t) => $t['name'], $tags);

    return [
        'genre' => $tagNames[0] ?? null,
        'style' => $tagNames[1] ?? null,
        'mood'  => $tagNames[2] ?? null,
        'theme' => $tagNames[3] ?? null,
    ];
}
?>
