<?php
require 'config.php';

$sql = "
SELECT
    t.id AS track_id,
    t.title,
    a.id AS artist_id,
    a.name AS artist_name,
    GROUP_CONCAT(DISTINCT g.id) AS genre_ids,
    GROUP_CONCAT(DISTINCT g.name) AS genres,
    GROUP_CONCAT(DISTINCT sg.id) AS subgenre_ids,
    GROUP_CONCAT(DISTINCT sg.name) AS subgenres,
    GROUP_CONCAT(DISTINCT tag.id) AS tag_ids,
    GROUP_CONCAT(DISTINCT tag.name) AS tags
FROM tracks t
JOIN artists a ON t.artist_id = a.id
LEFT JOIN track_genres tg ON t.id = tg.track_id
LEFT JOIN genres g ON tg.genre_id = g.id
LEFT JOIN track_subgenres ts ON t.id = ts.track_id
LEFT JOIN subgenres sg ON ts.subgenre_id = sg.id
LEFT JOIN track_tags tt ON t.id = tt.track_id
LEFT JOIN tags tag ON tt.tag_id = tag.id
GROUP BY t.id
LIMIT 20";
$stmt = $pdo->query($sql);
$tracks = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Track Browser</title>
    <style>
        td, th { padding: 5px; border: 1px solid #ccc; }
    </style>
</head>
<body>
    <h1>Track Browser</h1>
    <table>
        <tr>
            <th>Track Title</th>
            <th>Artist</th>
            <th>Genres</th>
            <th>Subgenres</th>
            <th>Tags</th>
        </tr>
        <?php foreach ($tracks as $track): ?>
        <tr>
            <td><?= htmlspecialchars($track['title']) ?></td>
            <td><a href='edit_artist.php?id=<?= $track['artist_id'] ?>'><?= htmlspecialchars($track['artist_name']) ?></a></td>
            <td><a href='edit_genres.php?track_id=<?= $track['track_id'] ?>'><?= htmlspecialchars($track['genres']) ?></a></td>
            <td><a href='edit_subgenres.php?track_id=<?= $track['track_id'] ?>'><?= htmlspecialchars($track['subgenres']) ?></a></td>
            <td><a href='edit_tags.php?track_id=<?= $track['track_id'] ?>'><?= htmlspecialchars($track['tags']) ?></a></td>
        </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>
