<?php
require 'config.php';
require 'Track.php';

header('Content-Type: application/json');
ob_clean();

$trackId = $_GET['track_id'] ?? null;
$mixStyle = $_GET['mix_style'] ?? null;

if (!$trackId) {
    echo json_encode(['error' => 'No track ID provided.']);
    exit;
}

// Load Camelot compatibility rules
$camelotMap = [];
$reverseCamelotMap = [];
$camelotStmt = $pdo->query("SELECT * FROM camelot_map");
foreach ($camelotStmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $camelotMap[$row['camelot_key']][$row['mix_type']][] = $row['compatible_key'];
    $reverseCamelotMap[$row['camelot_key'] . '->' . $row['compatible_key']] = $row['mix_type'];
}

// Fetch the starting track
$startTrackData = $pdo->query("SELECT * FROM tracks WHERE id = " . intval($trackId))->fetch(PDO::FETCH_ASSOC);
$startTrack = new Track($startTrackData);
$startBpm = intval($startTrackData['bpm']);
$startCamelot = $startTrackData['camelot'];

$recommendations = [];

$trackStmt = $pdo->query("SELECT t.*, v.vector FROM tracks t JOIN tracks_vector v ON t.id = v.track_id WHERE t.id != " . intval($trackId));

foreach ($trackStmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    // Skip if incomplete
    if (empty($row['vector']) || empty($row['camelot']) || empty($row['bpm'])) continue;

    $candidateBpm = intval($row['bpm']);
    $candidateCamelot = $row['camelot'];

    // Must be within ±8 BPM
    if (abs($candidateBpm - $startBpm) > 8) continue;

    // Must be a valid Camelot mix
    $mixKey = $startCamelot . '->' . $candidateCamelot;
    $mixType = $reverseCamelotMap[$mixKey] ?? null;

    if (!$mixType) continue; // skip if not compatible

    // If user filtered by mix style, apply it
    if ($mixStyle && $mixType !== $mixStyle) continue;

    $candidate = new Track($row);
    $distance = $startTrack->distance($candidate);

    $recommendations[] = [
        'track' => $row,
        'distance' => $distance,
        'mix_type' => $mixType
    ];
}

// Sort by distance, then exact key match, then BPM proximity
usort($recommendations, function ($a, $b) use ($startTrackData) {
    $cmp = $a['distance'] <=> $b['distance'];

    // If distance is equal, prefer exact camelot match
    if ($cmp === 0) {
        $camelotA = $a['track']['camelot'];
        $camelotB = $b['track']['camelot'];
        $startCamelot = $startTrackData['camelot'];

        if ($camelotA === $startCamelot && $camelotB !== $startCamelot) return -1;
        if ($camelotB === $startCamelot && $camelotA !== $startCamelot) return 1;
    }

    // If still equal, prefer closer BPM
    if ($cmp === 0) {
        $bpmA = abs(intval($a['track']['bpm']) - intval($startTrackData['bpm']));
        $bpmB = abs(intval($b['track']['bpm']) - intval($startTrackData['bpm']));
        return $bpmA <=> $bpmB;
    }

    return $cmp;
});

// Output
echo json_encode($recommendations);
exit;
