<?php
require 'config.php';

// Fetch tracks for dropdown
$stmt = $pdo->query("SELECT id, title, camelot FROM tracks ORDER BY title ASC");
$tracks = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Define available mix styles (ensure these match your camelot_map table)
$styles = ['PerfectMix', 'EnergyBoost', 'DownMix', 'Contrast'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Playlist Recommender</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body class="container py-5">
  <h2 class="mb-4">Generate Playlist Suggestions</h2>

  <div class="row mb-3">
    <div class="col-md-6">
      <label for="trackSelect" class="form-label">Select a Starting Track:</label>
      <select id="trackSelect" class="form-select">
        <option value="">-- Choose --</option>
        <?php foreach ($tracks as $t): ?>
          <option value="<?= $t['id'] ?>"><?= htmlspecialchars($t['title']) ?> (<?= $t['camelot'] ?>)</option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="col-md-6">
      <label for="mixStyle" class="form-label">Mix Style:</label>
      <select id="mixStyle" class="form-select">
        <option value="">-- Any --</option>
        <?php foreach ($styles as $style): ?>
          <option value="<?= $style ?>"><?= $style ?></option>
        <?php endforeach; ?>
      </select>
    </div>
  </div>

  <button id="recommendBtn" class="btn btn-primary">Recommend Tracks</button>

  <hr>
  <h4 class="mt-4">Recommendations:</h4>
  <table class="table table-striped mt-2" id="resultsTable">
    <thead>
      <tr>
        <th>Title</th>
        <th>Artist</th>
        <th>Camelot</th>
        <th>BPM</th>
        <th>Distance</th>
      </tr>
    </thead>
    <tbody></tbody>
  </table>

<script>
$('#recommendBtn').click(function() {
  const id = $('#trackSelect').val();
  const style = $('#mixStyle').val();

  if (!id) {
    alert('Please select a starting track.');
    return;
  }

  $('#resultsTable tbody').html('<tr><td colspan="5">Loading...</td></tr>');

  $.getJSON('recommend_playlist.php', { track_id: id, mix_style: style }, function(data) {
    if (!data.length) {
      $('#resultsTable tbody').html('<tr><td colspan="5">No matches found.</td></tr>');
      return;
    }

    const rows = data.map(row => `<tr>
      <td>${row.track.title}</td>
      <td>${row.track.artist}</td>
      <td>${row.track.camelot}</td>
      <td>${row.track.bpm}</td>
      <td>${row.distance.toFixed(3)}</td>
    </tr>`);

    $('#resultsTable tbody').html(rows.join(''));
  });
});
</script>
</body>
</html>
