<?php
require 'config.php';

header('Content-Type: application/json');
ob_clean();

$stmt = $pdo->query("SELECT tags FROM tracks WHERE tags IS NOT NULL AND tags != ''");
$allTags = [];

foreach ($stmt->fetchAll(PDO::FETCH_COLUMN) as $tagLine) {
    foreach (explode(',', $tagLine) as $tag) {
        $clean = trim(strtolower($tag));
        if ($clean) $allTags[$clean] = ucfirst($clean);
    }
}

echo json_encode(array_values($allTags));
