<?php
class Track {
    public $id, $title, $artist, $bpm, $energy, $danceability, $happiness,
           $acousticness, $instrumentalness, $liveness, $speechiness,
           $loudness, $camelot, $popularity, $genre, $vector;

    public function __construct($data) {
        $this->id = $data['id'];
        $this->title = $data['title'];
        $this->artist = $data['artist'];
        $this->bpm = $this->normalize((float)$data['bpm'], 60, 200);
        $this->energy = (float) $data['energy'];
        $this->danceability = (float) $data['danceability'];
        $this->happiness = (float) $data['happiness'];
        $this->acousticness = (float) $data['acousticness'];
        $this->instrumentalness = (float) $data['instrumentalness'];
        $this->liveness = (float) $data['liveness'];
        $this->speechiness = (float) $data['speechiness'];
        $this->loudness = $this->normalize((float) $data['loudness'], -60, 0);
        $this->camelot = $this->camelotToNumber($data['camelot']);
        $this->popularity = $this->normalize((float)$data['popularity'], 0, 100);
        $this->genre = $this->genreToValue($data['genre']);

        $this->vector = [
            $this->bpm,
            $this->energy,
            $this->danceability,
            $this->happiness,
            $this->acousticness,
            $this->instrumentalness,
            $this->liveness,
            $this->speechiness,
            $this->loudness,
            $this->camelot / 24,
            $this->popularity,
            $this->genre
        ];
    }

    private function normalize($value, $min, $max) {
        return ($value - $min) / ($max - $min);
    }

    private function camelotToNumber($camelot) {
        if (!$camelot) return 0;
        $num = intval(substr($camelot, 0, -1));
        $letter = strtoupper(substr($camelot, -1));
        return $letter === 'B' ? $num + 12 : $num;
    }

    private function genreToValue($genre) {
        if (!$genre) return 0;
        return (crc32(strtolower(trim($genre))) % 1000) / 1000;
    }
    
    public function distance(Track $other) {
    $sum = 0;
    for ($i = 0; $i < count($this->vector); $i++) {
        $sum += pow($this->vector[$i] - $other->vector[$i], 2);
    }
    return sqrt($sum);
}

}
?>
