<?php
session_start();
require 'config.php';

if (!isset($_SESSION['access_token'])) {
    header("Location: login.php");
    exit;
}

$accessToken = $_SESSION['access_token'];

function getUserPlaylists($accessToken) {
    $apiUrl = "https://api.spotify.com/v1/me/playlists?limit=50";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $accessToken"
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

$playlists = getUserPlaylists($accessToken);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Your Spotify Playlists</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-dark text-white">

<div class="container py-5">
    <a href="mixbuilder.php"><button class='btn btn-success'>Generate a playlist</button></a>
    <div class="row row-cols-1 row-cols-md-3 g-4">

        <?php foreach ($playlists['items'] as $playlist): ?>
            <div class="col">
                <div class="card h-100 bg-secondary text-white shadow">
                    <img src="<?= $playlist['images'][0]['url'] ?? 'https://via.placeholder.com/300x300' ?>" class="card-img-top" alt="Playlist Cover">
                    <div class="card-body">
                        <h5 class="card-title"><?= htmlspecialchars($playlist['name']) ?></h5>
                        <p class="card-text"><?= $playlist['tracks']['total'] ?> tracks</p>
                    </div>
                    <div class="card-footer bg-dark border-top-0 text-center">
                        <a href="tracks.php?playlist_id=<?= $playlist['id'] ?>" class="btn btn-outline-light btn-sm">View Tracks</a>
                        <a href="generate.php?playlist_id=<?= $playlist['id'] ?>" class="btn btn-outline-success btn-sm ms-2">Generate DJ Playlist</a>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>

    </div>
</div>

</body>
</html>
